/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

/**
 * Search input building a set of query parameters and calling
 * the callbacks to display / hide results
 */
'use strict';

exports.__esModule = true;
exports['default'] = React.createClass({
    displayName: 'SearchBox',

    propTypes: {
        // Required
        parameters: React.PropTypes.object.isRequired,
        queryParameterName: React.PropTypes.string.isRequired,
        // Other
        textLabel: React.PropTypes.string,
        displayResults: React.PropTypes.func,
        hideResults: React.PropTypes.func,
        displayResultsState: React.PropTypes.bool,
        limit: React.PropTypes.number
    },

    getInitialState: function getInitialState() {
        return {
            displayResult: this.props.displayResultsState ? true : false
        };
    },

    getDefaultProps: function getDefaultProps() {
        var dm = new PydioDataModel();
        dm.setRootNode(new AjxpNode());
        return { dataModel: dm };
    },

    displayResultsState: function displayResultsState() {
        this.setState({
            displayResult: true
        });
    },

    hideResultsState: function hideResultsState() {
        this.setState({
            displayResult: false
        });
        this.props.hideResults();
    },

    onClickSearch: function onClickSearch() {
        var value = this.refs.query.getValue();
        var dm = this.props.dataModel;
        var params = this.props.parameters;
        params[this.props.queryParameterName] = value;
        params['limit'] = this.props.limit || 100;
        dm.getRootNode().setChildren([]);
        PydioApi.getClient().request(params, (function (transport) {
            var remoteNodeProvider = new RemoteNodeProvider({});
            remoteNodeProvider.parseNodes(dm.getRootNode(), transport);
            dm.getRootNode().setLoaded(true);
            this.displayResultsState();
            this.props.displayResults(value, dm);
        }).bind(this));
    },

    keyDown: function keyDown(event) {
        if (event.key == 'Enter') {
            this.onClickSearch();
        }
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: this.props.className ? this.props.className : '' },
            React.createElement(
                'div',
                { style: { paddingTop: 22, float: 'right', opacity: 0.3 } },
                React.createElement(ReactMUI.IconButton, {
                    ref: 'button',
                    onClick: this.onClickSearch,
                    iconClassName: 'icon-search',
                    tooltip: 'Search'
                })
            ),
            React.createElement(
                'div',
                { className: 'searchbox-input-fill', style: { width: 220, float: 'right' } },
                React.createElement(ReactMUI.TextField, { ref: 'query', onKeyDown: this.keyDown, floatingLabelText: this.props.textLabel })
            )
        );
    }

});
module.exports = exports['default'];
