/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRedux = require('react-redux');

var _redux = require('redux');

var _materialUi = require('material-ui');

var _Player = require('./Player');

var _Player2 = _interopRequireDefault(_Player);

var _pydioUtilHasher = require('pydio/util/hasher');

var _pydioUtilHasher2 = _interopRequireDefault(_pydioUtilHasher);

var Editor = (function (_Component) {
    _inherits(Editor, _Component);

    function Editor(props) {
        _classCallCheck(this, Editor);

        _get(Object.getPrototypeOf(Editor.prototype), 'constructor', this).call(this, props);
        this.state = { showPlayer: true };
    }

    _createClass(Editor, [{
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            var _this = this;

            var sound = soundManager.getSoundById(nextProps.node.getPath());

            if (sound && this.props.node.getPath() !== nextProps.node.getPath()) {
                soundManager.soundIDs.map(function (soundID) {
                    try {
                        soundManager.sounds[soundID].stop();
                    } catch (e) {}
                });
                this.setState({ showPlayer: false }, function () {
                    _this.setState({ showPlayer: true });
                });
            }

            if (sound) {
                if (nextProps.selectionPlaying) {
                    sound.play();
                } else {
                    sound.pause();
                }
            }
        }
    }, {
        key: 'onRowsSelected',
        value: function onRowsSelected(rows) {
            if (!rows || !rows.length) return;
            var index = rows[0];
            var onRequestSelectionPlay = this.props.onRequestSelectionPlay;

            onRequestSelectionPlay(null, index, true);
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props;
            var node = _props.node;
            var selectionPlaying = _props.selectionPlaying;
            var selection = _props.selection;
            var onRequestSelectionPlay = _props.onRequestSelectionPlay;
            var showPlayer = this.state.showPlayer;

            console.log(selection, showPlayer);
            var url = undefined,
                crtIndex = 0;
            if (selection && showPlayer && node) {
                url = pydio.Parameters.get('ajxpServerAccess') + '&get_action=audio_proxy&file=' + encodeURIComponent(_pydioUtilHasher2['default'].base64_encode(node.getPath()));
                selection.selection.forEach(function (n, i) {
                    if (n.getPath() === node.getPath()) {
                        crtIndex = i;
                    }
                });
            }

            return _react2['default'].createElement(
                'div',
                { style: Editor.styles.container },
                url && _react2['default'].createElement(_Player2['default'], {
                    id: node.getPath(),
                    url: url,
                    rich: true,
                    style: { width: 250, height: 200, margin: "auto" },
                    onReady: function () {},
                    onPlay: function () {
                        onRequestSelectionPlay(null, crtIndex, true);
                    },
                    onPause: function () {
                        onRequestSelectionPlay(null, crtIndex, false);
                    },
                    disableAutoPlay: true,
                    onFinish: function () {
                        // Handle autoPlay here
                        if (selection && selection.selection && selection.selection[crtIndex + 1]) {
                            onRequestSelectionPlay(null, crtIndex + 1, true);
                        }
                    }
                }),
                _react2['default'].createElement(
                    _materialUi.Paper,
                    { zDepth: 1, style: Editor.styles.paper },
                    _react2['default'].createElement(
                        _materialUi.Table,
                        {
                            style: Editor.styles.table,
                            selectable: true,
                            multiSelectable: false,
                            onRowSelection: this.onRowsSelected.bind(this)
                        },
                        _react2['default'].createElement(
                            _materialUi.TableBody,
                            {
                                displayRowCheckbox: false,
                                stripedRows: false,
                                deselectOnClickaway: false
                            },
                            selection && selection.selection.map(function (n, index) {
                                var leftCol = index + 1;
                                var rowStyle = Editor.styles.row;
                                if (node && n.getPath() === node.getPath()) {
                                    if (selectionPlaying) {
                                        leftCol = _react2['default'].createElement('span', { className: "mdi mdi-pause", style: Editor.styles.leftColIcon, onClick: function () {
                                                onRequestSelectionPlay(null, index, false);
                                            } });
                                    } else {
                                        leftCol = _react2['default'].createElement('span', { className: "mdi mdi-play", style: Editor.styles.leftColIcon, onClick: function () {
                                                onRequestSelectionPlay(null, index, true);
                                            } });
                                    }
                                    rowStyle = Editor.styles.rowSelected;
                                }
                                return _react2['default'].createElement(
                                    _materialUi.TableRow,
                                    { key: index },
                                    _react2['default'].createElement(
                                        _materialUi.TableRowColumn,
                                        { style: _extends({}, Editor.styles.leftCol, rowStyle) },
                                        leftCol
                                    ),
                                    _react2['default'].createElement(
                                        _materialUi.TableRowColumn,
                                        { style: rowStyle },
                                        n.getLabel()
                                    )
                                );
                            })
                        )
                    )
                )
            );
        }
    }], [{
        key: 'styles',
        get: function get() {
            return {
                container: {
                    margin: "auto",
                    display: "flex",
                    flexDirection: "column",
                    justifyContent: "space-between",
                    flex: 1,
                    backgroundColor: '#fafafa'
                },
                player: {
                    margin: "auto"
                },
                paper: {
                    margin: 10
                },
                table: {
                    width: "100%"
                },
                row: {
                    backgroundColor: 'transparent'
                },
                rowSelected: {
                    backgroundColor: '#fafafa'
                },
                leftCol: {
                    width: 60,
                    textAlign: 'center',
                    paddingRight: 0
                },
                leftColIcon: {
                    cursor: 'pointer'
                }
            };
        }
    }]);

    return Editor;
})(_react.Component);

function guid() {
    return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
}

function s4() {
    return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
}

var _PydioHOCs = PydioHOCs;
var withSelection = _PydioHOCs.withSelection;
var withMenu = _PydioHOCs.withMenu;
var withLoader = _PydioHOCs.withLoader;
var withErrors = _PydioHOCs.withErrors;
var withControls = _PydioHOCs.withControls;

var editors = pydio.Registry.getActiveExtensionByType("editor");
var conf = editors.filter(function (_ref) {
    var id = _ref.id;
    return id === 'editor.soundmanager';
})[0];

var getSelectionFilter = function getSelectionFilter(node) {
    return conf.mimes.indexOf(node.getAjxpMime()) > -1;
};

var getSelection = function getSelection(node) {
    return new Promise(function (resolve, reject) {
        var selection = [];

        node.getParent().getChildren().forEach(function (child) {
            return selection.push(child);
        });
        selection = selection.filter(getSelectionFilter);

        resolve({
            selection: selection,
            currentIndex: selection.reduce(function (currentIndex, current, index) {
                return current === node && index || currentIndex;
            }, 0)
        });
    });
};

var getTime = function getTime(nMSec, bAsString) {

    // convert milliseconds to mm:ss, return as object literal or string
    var nSec = Math.floor(nMSec / 1000),
        min = Math.floor(nSec / 60),
        sec = nSec - min * 60;
    // if (min === 0 && sec === 0) return null; // return 0:00 as null
    return bAsString ? min + ':' + (sec < 10 ? '0' + sec : sec) : { 'min': min, 'sec': sec };
};

exports['default'] = (0, _redux.compose)(withSelection(getSelection), (0, _reactRedux.connect)())(Editor);
module.exports = exports['default'];
