/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('react');

var Component = _require.Component;
var PropTypes = _require.PropTypes;

/**
 * Ready to use Form + Result List for search users
 */

var SearchForm = (function (_Component) {
    _inherits(SearchForm, _Component);

    function SearchForm(props, context) {
        _classCallCheck(this, SearchForm);

        _Component.call(this, props.context);
        this.state = { value: '' };
    }

    SearchForm.prototype.search = function search() {
        this.props.onSearch(this.state.value);
    };

    SearchForm.prototype.onChange = function onChange(event, value) {
        this.setState({ value: value });
        FuncUtils.bufferCallback('search_users_list', 300, this.search.bind(this));
    };

    SearchForm.prototype.render = function render() {

        return React.createElement(
            'div',
            { style: _extends({ minWidth: 320 }, this.props.style) },
            React.createElement(MaterialUI.TextField, {
                fullWidth: true,
                value: this.state.value,
                onChange: this.onChange.bind(this),
                hintText: this.props.searchLabel
            })
        );
    };

    return SearchForm;
})(Component);

SearchForm.propTypes = {
    /**
     * Label displayed in the search field
     */
    searchLabel: PropTypes.string.isRequired,
    /**
     * Callback triggered to search
     */
    onSearch: PropTypes.func.isRequired,
    /**
     * Will be appended to the root element
     */
    style: PropTypes.object
};

exports['default'] = SearchForm;
module.exports = exports['default'];
