/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

exports.__esModule = true;
var React = require('react');
var PydioApi = require('pydio/http/api');
var BootUI = require('pydio/http/resources-manager').requireLib('boot');
var ActionDialogMixin = BootUI.ActionDialogMixin;
var SubmitButtonProviderMixin = BootUI.SubmitButtonProviderMixin;
var Loader = BootUI.Loader;

var SplashDialog = React.createClass({
    displayName: 'SplashDialog',

    mixins: [ActionDialogMixin, SubmitButtonProviderMixin],

    getDefaultProps: function getDefaultProps() {
        return {
            dialogTitle: '',
            dialogSize: 'lg',
            dialogIsModal: false,
            dialogPadding: false,
            dialogScrollBody: true
        };
    },
    submit: function submit() {
        this.dismiss();
    },

    getInitialState: function getInitialState() {
        return { aboutContent: null };
    },

    componentDidMount: function componentDidMount() {

        PydioApi.getClient().request({
            get_action: 'display_doc',
            doc_file: 'CREDITS'
        }, (function (transport) {
            this.setState({
                aboutContent: transport.responseText
            });
        }).bind(this));
    },

    render: function render() {
        var _this = this;

        if (!this.state.aboutContent) {
            return React.createElement(Loader, { style: { minHeight: 200 } });
        } else {
            var ct = function ct() {
                return { __html: _this.state.aboutContent };
            };
            return React.createElement('div', { style: { fontSize: 13, padding: '0 10px' }, dangerouslySetInnerHTML: ct() });
        }
    }

});

exports['default'] = SplashDialog;
module.exports = exports['default'];
