/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import PropTypes from 'prop-types';

/**
 * Internal dependencies
 */
import './style.scss';

/**
 * Display a preview for a given product.
 */
const ProductPreview = ( { product } ) => {
	const { placeholderImgSrc } = wc_product_block_data; /* eslint-disable-line camelcase */

	let image = null;
	if ( product.images.length ) {
		image = <img src={ product.images[ 0 ].src } alt="" />;
	} else {
		image = <img src={ placeholderImgSrc } alt="" />;
	}

	return (
		<div className="wc-product-preview">
			{ image }
			<div className="wc-product-preview__title">{ product.name }</div>
			<div
				className="wc-product-preview__price"
				dangerouslySetInnerHTML={ { __html: product.price_html } }
			/>
			<span className="wp-block-button">
				<span className="wc-product-preview__add-to-cart wp-block-button__link">
					{ __( 'Add to cart', 'woo-gutenberg-products-block' ) }
				</span>
			</span>
		</div>
	);
};

ProductPreview.propTypes = {
	/**
	 * The product object as returned from the API.
	 */
	product: PropTypes.shape( {
		id: PropTypes.number,
		images: PropTypes.array,
		name: PropTypes.string,
		price_html: PropTypes.string,
	} ).isRequired,
};

export default ProductPreview;
