<?php

namespace PodlovePublisher_Vendor;

/**
 * This file is part of Twig.
 *
 * (c) 2009 Fabien Potencier
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
/**
 * @author Henrik Bjornskov <hb@peytz.dk>
 */
class Twig_Extensions_Extension_Text extends Twig_Extension
{
    /**
     * {@inheritdoc}
     */
    public function getFilters()
    {
        return array(new Twig_SimpleFilter('truncate', 'twig_truncate_filter', array('needs_environment' => \true)), new Twig_SimpleFilter('wordwrap', 'twig_wordwrap_filter', array('needs_environment' => \true)));
    }
    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'Text';
    }
}
/**
 * This file is part of Twig.
 *
 * (c) 2009 Fabien Potencier
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
/**
 * @author Henrik Bjornskov <hb@peytz.dk>
 */
@\class_alias('PodlovePublisher_Vendor\\Twig_Extensions_Extension_Text', 'Twig_Extensions_Extension_Text', \false);
if (\function_exists('mb_get_info')) {
    function twig_truncate_filter(Twig_Environment $env, $value, $length = 30, $preserve = \false, $separator = '...')
    {
        if (\mb_strlen($value, $env->getCharset()) > $length) {
            if ($preserve) {
                // If breakpoint is on the last word, return the value without separator.
                if (\false === ($breakpoint = \mb_strpos($value, ' ', $length, $env->getCharset()))) {
                    return $value;
                }
                $length = $breakpoint;
            }
            return \rtrim(\mb_substr($value, 0, $length, $env->getCharset())) . $separator;
        }
        return $value;
    }
    function twig_wordwrap_filter(Twig_Environment $env, $value, $length = 80, $separator = "\n", $preserve = \false)
    {
        $sentences = array();
        $previous = \mb_regex_encoding();
        \mb_regex_encoding($env->getCharset());
        $pieces = \mb_split($separator, $value);
        \mb_regex_encoding($previous);
        foreach ($pieces as $piece) {
            while (!$preserve && \mb_strlen($piece, $env->getCharset()) > $length) {
                $sentences[] = \mb_substr($piece, 0, $length, $env->getCharset());
                $piece = \mb_substr($piece, $length, 2048, $env->getCharset());
            }
            $sentences[] = $piece;
        }
        return \implode($separator, $sentences);
    }
} else {
    function twig_truncate_filter(Twig_Environment $env, $value, $length = 30, $preserve = \false, $separator = '...')
    {
        if (\strlen($value) > $length) {
            if ($preserve) {
                if (\false !== ($breakpoint = \strpos($value, ' ', $length))) {
                    $length = $breakpoint;
                }
            }
            return \rtrim(\substr($value, 0, $length)) . $separator;
        }
        return $value;
    }
    function twig_wordwrap_filter(Twig_Environment $env, $value, $length = 80, $separator = "\n", $preserve = \false)
    {
        return \wordwrap($value, $length, $separator, !$preserve);
    }
}
@\class_alias('PodlovePublisher_Vendor\\Twig_Extensions_Extension_Text', 'PodlovePublisher_Vendor\\Twig\\Extensions\\TextExtension', \false);
